<?php
#########################################################
#                                                       #
#  ELVATPCI / DIRECT DEBIT PCI payment method class     #
#  This module is used for real time processing of      #
#  Austrian Bankdata of customers.                      #
#                                                       #
#  Copyright (c) 2012 Novalnet AG                       #
#                                                       #
#  Released under the GNU General Public License        #
#  novalnet_elv_at_pci module.                          #
#  This free contribution made by request.              #
#  If you have found this script usefull a small        #
#  recommendation as well as a comment on merchant form #
#  would be greatly appreciated.                        #
#                                                       #
#  Script : novalnet_elv_at_pci.php                     #
#  Version: 1.0.3  2012-06-13                           #
#########################################################

class novalnet_elv_at_pci {

  var $code;
  var $title;
  var $description;
  var $enabled;
  var $is_ajax = false;
  var $key;
  var $implementation;
  var $KEY = 8;
  var $tot_amount;

  function novalnet_elv_at_pci() {
    global $order;

    $this->code         = 'novalnet_elv_at_pci';
    $this->title        = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_TITLE;
    $this->public_title = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_PUBLIC_TITLE;
    $this->description  = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_DESCRIPTION;
    $this->sort_order   = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_SORT_ORDER;
    $this->enabled      = ((MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_STATUS == 'True') ? true : false);
    $this->proxy        = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PROXY;
	$this->key 			= trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PASSWORD);
	$this->implementation  = 'PHP_PCI';#'JAVA', 'PHP', '', if empty, then equal to 'PHP'
	if(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_LOGO_STATUS != 'Disable'){
		$this->public_title = '<NOBR><A HREF="https://www.novalnet.de/de/unsere-produkte/zahlungsarten.html" TARGET="_new"><IMG SRC="https://www.novalnet.de/img/NN_Logo_T.png" ALT="Zahlung per Novalnet AG" title="Zahlung per Novalnet AG" BORDER="0"></A>'.MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_PUBLIC_TITLE;
	}	
	if (CHECKOUT_AJAX_STAT=='true') { $this->is_ajax = true; }
	
	#check encoded data
    if ($_REQUEST['hash2'] && $_SESSION['payment'] == $this->code){
      if (strtoupper($this->implementation) == 'JAVA'){#Java encoded
        if ( $_REQUEST['auth_code'] != md5(trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_AUTH_CODE).strrev($this->key)) ){
          $err = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_HASH_ERROR.'; wrong auth_code!';
          $payment_error_return = 'payment_error=novalnet_elv_at_pci&error='.$_REQUEST['status_text'].'; '.utf8_encode($err);
			if ($this->is_ajax) {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, $payment_error_return, 'SSL', true, false));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
			}
         // xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
        }
        $_REQUEST['auth_code']  = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_AUTH_CODE;#todo: check?
        $_REQUEST['product_id'] = $this->encode4java($_REQUEST['product'],   'bindec');
        $_REQUEST['tariff_id']  = $this->encode4java($_REQUEST['tariff'],    'bindec');
        $_REQUEST['amount']     = $this->encode4java($_REQUEST['amount'],    'bindec');
        $_REQUEST['test_mode']  = $this->encode4java($_REQUEST['test_mode'], 'bindec');
        $_REQUEST['uniqid']     = $this->encode4java($_REQUEST['uniqid'],    'bindec');

        if (!$this->checkHash4java($_REQUEST)){#PHP encoded
          $err = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_HASH_ERROR;
          $payment_error_return = 'payment_error=novalnet_elv_at_pci&error='.$_REQUEST['status_text'].'; '.utf8_encode($err);
			if ($this->is_ajax) {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, $payment_error_return, 'SSL', true, false));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
			}
          //xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
        }
      }else{#PHP encoded
        if (!$this->checkHash($_REQUEST)){
          $err = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_HASH_ERROR;
          $payment_error_return = 'payment_error=novalnet_elv_at_pci&error='.$_REQUEST['status_text'].'; '.utf8_encode($err);
		  	if ($this->is_ajax) {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, $payment_error_return, 'SSL', true, false));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
			}

         // xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
        }else{
        $_REQUEST['auth_code']  = $this->decode($_REQUEST['auth_code']);
        $_REQUEST['product_id'] = $this->decode($_REQUEST['product_id']);
        $_REQUEST['tariff_id']  = $this->decode($_REQUEST['tariff_id']);
        $_REQUEST['amount']     = $this->decode($_REQUEST['amount']);
        $_REQUEST['test_mode']  = $this->decode($_REQUEST['test_mode']);
        $_REQUEST['uniqid']     = $this->decode($_REQUEST['uniqid']);
        }
      }
    }

    if ((int)MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ORDER_STATUS_ID > 0) {
      $this->order_status = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ORDER_STATUS_ID;
    }

    if (is_object($order)) $this->update_status();
    $this->form_action_url = 'https://payport.novalnet.de/pci_payport';
    if($_POST['session'] && $_SESSION['payment'] == $this->code) {
      $this->checkSecurity();
    }
  }
  
  ### calculate zone matches and flag settings to determine whether this module should display to customers or not ###
  function update_status() {
    global $order;

    if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ZONE > 0) ) {
      $check_flag = false;
      $check_query = xtc_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = xtc_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

      if ($check_flag == false) {
        $this->enabled = false;
      }
    }
  }
  
  ### JS validation which does error-checking of data-entry if this module is selected for use ###
  ### the fields to be cheked are (Bank Owner, Bank Account Number and Bank Code Lengths)      ###
  ### currently this function is not in use ###
  // @return string
  function javascript_validation() {
    return false;
  }
 
  ### Builds set of input fields for collecting Bankdetail info ###
  // @return array
  function selection() {
    global $xtPrice, $order, $HTTP_POST_VARS, $_POST;

    $onFocus = '';
    if(count($HTTP_POST_VARS)==0 || $HTTP_POST_VARS=='') $HTTP_POST_VARS = $_POST;

    $selection = array('id' => $this->code,
                       'module' => $this->public_title,
                        'fields' => array(array())
                      );

    if(function_exists(get_percent))
    {
        $selection['module_cost'] = $GLOBALS['ot_payment']->get_percent($this->code);
    }

    return $selection;
  }

  ### Precheck to Evaluate the Bank Datas ###
  function pre_confirmation_check($vars) {
    global $HTTP_POST_VARS, $_POST, $order;
	
	if(!$this->emailVaildate($order->customer['email_address'])) {
      $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode(utf8_encode('Please enter the valid email Id'));
	  if ($this->is_ajax) {
			$_SESSION['checkout_payment_error'] = $payment_error_return;
	  } else {
		    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
	  }
    }
    if(!is_array($HTTP_POST_VARS) && !$HTTP_POST_VARS)
	{
		$HTTP_POST_VARS = array();
	}
	if ($this->is_ajax) {
		$HTTP_POST_VARS = array_merge($HTTP_POST_VARS,$vars);
	} else {
		$HTTP_POST_VARS = array_merge($HTTP_POST_VARS,$_POST);
	}
    $error = '';

    if (defined('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_MANUAL_CHECK_LIMIT') and trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_MANUAL_CHECK_LIMIT)){
      if ( (!defined('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID2') or !trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID2) or preg_match('/[^\d]/', trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID2))) or (!defined('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID2') or !trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID2) or preg_match('/[^\d]/', trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID2)))){
           $error = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_JS_NN_ID2_MISSING;
      }
    }

    if(!trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_VENDOR_ID) || !trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_AUTH_CODE) || !trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID) || !trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID) || !trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PASSWORD))
    {
      $error = MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_JS_NN_MISSING;
    }

    if($error!='') {
      $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode(utf8_encode($error));
	  if ($this->is_ajax) {
		$_SESSION['checkout_payment_error'] = $payment_error_return;
		} else {
		xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
		}
    }
  }

  ### Display Information on the Checkout Confirmation Page ###
  // @return array
  function confirmation() {
    global $HTTP_POST_VARS, $_POST, $order;

    if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
      $total = $order->info['total'] + $order->info['tax'];
    } else {
      $total = $order->info['total'];
    }
    $_SESSION['nn_total_elv_at_pci'] = sprintf('%.2f', $total);

    if(count($HTTP_POST_VARS)==0 || $HTTP_POST_VARS=='') $HTTP_POST_VARS = $_POST;
    #print "in confirmation"; exit;

    return $confirmation;
  }

  //This is user defined function used for getting order amount in cents with tax
  public function findTotalAmount(){
		global $order;
		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
		  $total = $order->info['total'] + $order->info['tax'];
		} else {
		  $total = $order->info['total'];
		}
		if (preg_match('/[^\d\.]/', $total) or !$total){
			### $amount contains some unallowed chars or empty ###
			$err                      = 'amount ('.$total.') is empty or has a wrong format';
			$payment_error_return     = 'payment_error='.$this->code.'&error='.utf8_encode($err);
			if ($this->is_ajax) {
				$_SESSION['checkout_payment_error'] = $payment_error_return;
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
			}
		}
		$amount = sprintf('%0.2f', $total);
		$amount = preg_replace('/^0+/', '', $amount);
		$amount = str_replace('.', '', $amount);
	return $amount;
  }
  
  ### Build the data and actions to process when the "Submit" button is pressed on the order-confirmation screen. ###
  ### These are hidden fields on the checkout confirmation page ###
  // @return string
  function process_button() {
    global $HTTP_POST_VARS, $_POST, $order, $currencies, $customer_id;
    if(count($HTTP_POST_VARS)==0 || $HTTP_POST_VARS=='') $HTTP_POST_VARS = $_POST;

    #Get the required additional customer details from DB
    $customer_query = xtc_db_query("SELECT customers_gender, customers_dob, customers_fax FROM ". TABLE_CUSTOMERS . " WHERE customers_id='". (int)$customer_id ."'");
    $customer = xtc_db_fetch_array($customer_query);

    list($customer['customers_dob'], $extra) = explode(' ', $customer['customers_dob']);

    $this->tot_amount = $amount = $this->findTotalAmount();
	//echo "Amount ".$amount; exit;
	$vendor_id    = trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_VENDOR_ID);
    $auth_code    = trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_AUTH_CODE);

	list($product_id, $tariff_id) = $this->get_prod_tarif_id($amount);
	//file_put_contents('file_print_for_ATPCI.txt', "Product Id :".$product_id."<BR>Tariff id: ".$tariff_id."<BR>Total Amount :".$this->tot_amount);
    $uniqid       = uniqid();
    $test_mode    = (strtolower(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE) == 'true' or MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE == '1')? 1: 0;
	$_SESSION['test_mode_elv_at_pci']=$test_mode;
    if (strtoupper($this->implementation) == 'JAVA'){
      $uniqid       = time();#must ne a long integer
      $hash         = md5($auth_code.$product_id.$tariff_id.$amount.$test_mode.$uniqid.strrev($this->key));
      $auth_code    = md5($auth_code.strrev($this->key));
      $product_id   = $this->encode4java($product_id, 'decbin');
      $tariff_id    = $this->encode4java($tariff_id, 'decbin');
      $amount       = $this->encode4java($amount, 'decbin');
      $test_mode    = $this->encode4java($test_mode, 'decbin');
      $uniqid       = $this->encode4java($uniqid, 'decbin');

    }else{
      $auth_code    = $this->encode($auth_code);
      $product_id   = $this->encode($product_id);
      $tariff_id    = $this->encode($tariff_id);
      $amount       = $this->encode($amount);
      $test_mode    = $this->encode($test_mode);
      $uniqid       = $this->encode($uniqid);
      $hash         = $this->hash(array('auth_code' => $auth_code, 'product_id' => $product_id, 'tariff' => $tariff_id, 'amount' => $amount, 'test_mode' => $test_mode, 'uniqid' => $uniqid));
	 // echo 'hasho auth_code'.$auth_code.'<br>product_id'.$product_id.'<br>tariff'.$tariff_id.'<br>amount'.$amount.'<br>test_mode'.$test_mode.'<br>uniqid'.$uniqid; exit;
    }
	
    $user_ip = $this->getRealIpAddr();

    if($this->is_ajax) 
		$checkout_url = xtc_href_link(FILENAME_CHECKOUT, '', 'SSL');
	else 
		$checkout_url = xtc_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL');

    if(strstr($checkout_url, '?'))
    {
      $checkout_url = str_replace(' ', '', $checkout_url);
      if(substr($checkout_url,-1)=='?')$error_url = $checkout_url.'payment_error=novalnet_elv_at_pci&error=$ERROR_MESSAGE ($STATUS)';
      else $error_url = $checkout_url.'&payment_error=novalnet_elv_at_pci&error=$ERROR_MESSAGE ($STATUS)';
    }
    else $error_url = $checkout_url.'?payment_error=novalnet_elv_at_pci&error=$ERROR_MESSAGE ($STATUS)';

    //$test_mode = (strtolower(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE) == 'true' or MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE == '1')? 1: 0;

    $process_button_string = xtc_draw_hidden_field('vendor_id', $vendor_id) .
       xtc_draw_hidden_field('product_id', $product_id) .
       xtc_draw_hidden_field('payment_id', $this->KEY) .
       xtc_draw_hidden_field('tariff_id', $tariff_id) .
       xtc_draw_hidden_field('vendor_authcode', $auth_code) .
	   xtc_draw_hidden_field('uniqid',    $uniqid) .
       xtc_draw_hidden_field('currency', $order->info['currency']) .
       xtc_draw_hidden_field('amount', $amount) .
	   xtc_draw_hidden_field('hash', $hash) .
       xtc_draw_hidden_field('gender', 'u') .
       xtc_draw_hidden_field('firstname', $this->ReplaceSpecialGermanChars($order->customer['firstname'])) .
       xtc_draw_hidden_field('lastname', $this->ReplaceSpecialGermanChars($order->customer['lastname'])) .
       xtc_draw_hidden_field('email',  $this->ReplaceSpecialGermanChars($order->customer['email_address'])) .
       xtc_draw_hidden_field('street', $this->ReplaceSpecialGermanChars($order->customer['street_address'])) .
       xtc_draw_hidden_field('search_in_street', '1') .
       xtc_draw_hidden_field('city', $this->ReplaceSpecialGermanChars($order->customer['city'])) .
       xtc_draw_hidden_field('zip', $order->customer['postcode']) .
       xtc_draw_hidden_field('country_code', $order->customer['country']['iso_code_2']) .
       xtc_draw_hidden_field('lang', MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_LANG) .
       xtc_draw_hidden_field('remote_ip', $user_ip) .
       xtc_draw_hidden_field('tel', $order->customer['telephone']) .
       xtc_draw_hidden_field('fax', $customer['customers_fax']) .
       xtc_draw_hidden_field('birthday', $customer['customers_dob']) .
       xtc_draw_hidden_field('session', $_COOKIE['XTCsid']) .
       xtc_draw_hidden_field('return_url', xtc_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')) .
       xtc_draw_hidden_field('return_method', 'POST') .
       xtc_draw_hidden_field('error_return_url', $error_url) .
       xtc_draw_hidden_field('test_mode', $test_mode) .
	   xtc_draw_hidden_field('implementation', strtoupper($this->implementation)) .
       xtc_draw_hidden_field('error_return_method', 'POST').	   xtc_draw_hidden_field('tot_amount', $this->tot_amount);

    return $process_button_string;
  }
	/*
	 * Get Product and Tariff Id function 
	 */ 
	function get_prod_tarif_id($amount) {
		$product_id   		= trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID);
    	$tariff_id    		= trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID);
	
    	$manual_check_limit = trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_MANUAL_CHECK_LIMIT);
    	$manual_check_limit = str_replace(',', '', $manual_check_limit);
    	$manual_check_limit = str_replace('.', '', $manual_check_limit);
		
    	if($manual_check_limit && (int)$amount>=$manual_check_limit){
      		$product_id = trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID2);
      		$tariff_id  = trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID2);
    	}			
		return array($product_id, $tariff_id);		
	}
	// End : Get Product and Tariff Id function 
  ### Insert the Novalnet Transaction ID in DB ###
  function before_process() {
    global $_POST, $order;
	if( $this->order_status )
		$order->info['order_status'] = $this->order_status;
	$this->tot_amount = $_POST['tot_amount'];
    $test_mode = (strtolower(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE) == 'true' or MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE == '1')? 1: 0;
	if ($this->decode($_POST['test_mode']) == 1 || $test_mode == 1){
		$order->info['comments'] .= MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_ORDER_MESSAGE;
	}	
	$order->info['comments'] .= MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TID_MESSAGE.$_POST['tid'];
	$order->info['comments']  = str_replace(array('<b>', '</b>','<B>','</B>', '<br>','<br />','<BR>'), array('', '', '','',"\n", "\n","\n"), $order->info['comments']);	
	$_SESSION['nn_tid_elv_at_pci']=$_POST['tid'];
  }

  function isPublicIP($value)
  {
        if(!$value || count(explode('.',$value))!=4) return false;
        return !preg_match('~^((0|10|172\.16|192\.168|169\.254|255|127\.0)\.)~', $value);
  }

  ### get the real Ip Adress of the User ###
  function getRealIpAddr()
  {
        if($this->isPublicIP($_SERVER['HTTP_X_FORWARDED_FOR'])) return $_SERVER['HTTP_X_FORWARDED_FOR'];
        if($iplist=explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            if($this->isPublicIP($iplist[0])) return $iplist[0];
        }
        if ($this->isPublicIP($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
        if ($this->isPublicIP($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
        if ($this->isPublicIP($_SERVER['HTTP_FORWARDED_FOR']) ) return $_SERVER['HTTP_FORWARDED_FOR'];

        return $_SERVER['REMOTE_ADDR'];
  }

  ### replace the Special German Charectors ###
  function ReplaceSpecialGermanChars($string)
  {
     $what = array("ä", "ö", "ü", "Ä", "Ö", "Ü", "ß");
     $how = array("ae", "oe", "ue", "Ae", "Oe", "Ue", "ss");

     $string = str_replace($what, $how, $string);

     return $string;
  }
  ### for email validation ###
  function emailVaildate($email){
	if (!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $email)){
		return false; //Invalid email
	}else{
		return true;  //Valid email
	} 
  }
 ### Send the order detail to Novalnet ###
  function after_process() {
    global $order, $insert_id;
	
    if ($this->order_status){
      xtc_db_query("UPDATE ".TABLE_ORDERS." SET orders_status='".$this->order_status."' WHERE orders_id='".$insert_id."'");
    }
	
	list($product_id, $tariff_id) = $this->get_prod_tarif_id($this->tot_amount);
	 //print "$product_id, $tariff_id, $this->tot_amount";exit;
	if(isset($_SESSION['nn_tid_elv_at_pci'])){
		$url = 'https://payport.novalnet.de/paygate.jsp';
		$urlparam = 'vendor='.trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_VENDOR_ID).'&product='.$product_id.'&key='.$this->KEY.'&tariff='.$tariff_id;
		$urlparam .= '&order_no='.$insert_id;
		$urlparam .= '&auth_code='.trim(MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_AUTH_CODE).'&status=100&tid='.$_SESSION['nn_tid_elv_at_pci'].'&reference=BNR-'.$insert_id.'&vwz2='.MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_ORDERNO.''.$insert_id.'&vwz3='.MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_ORDERDATE.''.date('Y-m-d H:i:s');
		unset($_SESSION['nn_tid_elv_at_pci']);
		//echo "URL PARAM : ".$urlparam; exit;
		$this->perform_https_request($url, $urlparam);
	}
	unset($_SESSION['nn_tid_elv_at_pci']);
	return false;
  }

  ### Used to display error message details ###
  // @return array
  function get_error() {
    global $HTTP_GET_VARS, $_GET;
	if ($this->is_ajax) {
		unset($_SESSION['shipping']);	
	}
    if(count($HTTP_GET_VARS)==0 || $HTTP_GET_VARS=='') $HTTP_GET_VARS = $_GET;

    //$error = array('title' => MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_ERROR, 'error' => stripslashes(utf8_decode($HTTP_GET_VARS['error'])));
	$error = array('title' => MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEXT_ERROR, 'error' => stripslashes(urldecode($HTTP_GET_VARS['error'])));

    return $error;
  }

  ### Check to see whether module is installed ###
  // @return boolean
  function check() {
    if (!isset($this->_check)) {
      $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_STATUS'");
      $this->_check = xtc_db_num_rows($check_query);
    }
    return $this->_check;
  }

  ### Install the payment module and its configuration settings ###
  function install() {

    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ALLOWED', '', '6', '0', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_LOGO_STATUS', 'Enable', '6', '2', 'xtc_cfg_select_option(array(\'Enable\', \'Disable\'), ', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE', 'True', '6', '3', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_VENDOR_ID', '', '6', '4', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_AUTH_CODE', '', '6', '5', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID', '', '6', '6', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID', '', '6', '7', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_MANUAL_CHECK_LIMIT', '', '6', '8', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID2', '', '6', '9', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID2', '', '6', '10', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PASSWORD', '', '6', '11', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_BOOK_REF', '', '6', '12', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_SORT_ORDER', '0', '6', '13', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ORDER_STATUS_ID', '0', '6', '14', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ZONE', '0', '6', '15', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PROXY', '', '6', '16', now())");
  }
   
  ### Remove the module and all its settings ###
  function remove() {
    xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }

  ### Internal list of configuration keys used for configuration of the module ###
  // @return array
  function keys() {
    return array('MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ALLOWED', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_STATUS', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_LOGO_STATUS', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TEST_MODE', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_VENDOR_ID', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_AUTH_CODE', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_MANUAL_CHECK_LIMIT', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PRODUCT_ID2', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_TARIFF_ID2', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PASSWORD','MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_BOOK_REF', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_SORT_ORDER', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ORDER_STATUS_ID', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_ZONE', 'MODULE_PAYMENT_NOVALNET_ELV_AT_PCI_PROXY');
  }

	function html_to_utf8 ($data)
	{
		return preg_replace("/\\&\\#([0-9]{3,10})\\;/e", '$this->_html_to_utf8("\\1")', $data);
	}

	function _html_to_utf8 ($data)
	{
		if ($data > 127)
		{
			$i = 5;
			while (($i--) > 0)
			{
				if ($data != ($a = $data % ($p = pow(64, $i))))
				{
					$ret = chr(base_convert(str_pad(str_repeat(1, $i + 1), 8, "0"), 2, 10) + (($data - $a) / $p));
					for ($i; $i > 0; $i--)
						$ret .= chr(128 + ((($data % pow(64, $i)) - ($data % ($p = pow(64, $i - 1)))) / $p));
					break;
				}
			}
		}
		else
		{
			$ret = "&#$data;";
		}
		return $ret;
	}

	### Realtime accesspoint for communication to the Novalnet paygate ###
  function perform_https_request($nn_url, $urlparam)
  {
      $debug = 0;#set it to 1 if you want to activate the debug mode

      if($debug) print "<BR>perform_https_request: $nn_url<BR>\n\r\n";
      if($debug) print "perform_https_request: $urlparam<BR>\n\r\n";

      ## some prerquisites for the connection
      $ch = curl_init($nn_url);
      curl_setopt($ch, CURLOPT_POST, 1);  // a non-zero parameter tells the library to do a regular HTTP post.
      curl_setopt($ch, CURLOPT_POSTFIELDS, $urlparam);  // add POST fields
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);  // don't allow redirects
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);  // decomment it if you want to have effective ssl checking
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  // decomment it if you want to have effective ssl checking
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  // return into a variable
      curl_setopt($ch, CURLOPT_TIMEOUT, 240);  // maximum time, in seconds, that you'll allow the CURL functions to take
      if ($this->proxy) {curl_setopt($ch, CURLOPT_PROXY, $this->proxy); }

      ## establish connection
      $data = curl_exec($ch);
      $data = $this->ReplaceSpecialGermanChars($data);

      ## determine if there were some problems on cURL execution
      $errno = curl_errno($ch);
      $errmsg = curl_error($ch);

      ###bug fix for PHP 4.1.0/4.1.2 (curl_errno() returns high negative value in case of successful termination)
      if($errno < 0) $errno = 0;
      ##bug fix for PHP 4.1.0/4.1.2

      if($debug)
      {
        print_r(curl_getinfo($ch));
        echo "\n<BR><BR>\n\n\nperform_https_request: cURL error number:" . $errno . "\n<BR>\n\n";
        echo "\n\n\nperform_https_request: cURL error:" . $errmsg . "\n<BR>\n\n";
      }

      #close connection
      curl_close($ch);

      ## read and return data from novalnet paygate
      if($debug) print "<BR>\n\n" . $data . "\n<BR>\n\n";

      return array ($errno, $errmsg, $data);
  }

  function debug2($object, $filename, $debug = false) {
    if (!$debug){return;}
    $fh = fopen("/tmp/$filename", 'a+');
      fwrite($fh, date('Y-m-d H:i:s').' '.print_r($object, true));
    fwrite($fh, "<hr />\n");
    fclose($fh);
  }

  function checkSecurity() {
    global $_POST, $order, $insert_id; 
   
    if(strlen(trim($_POST['tid']))==17 && $_POST['status']==100 && $_POST['session']==$_COOKIE['XTCsid']) 
    {
      #xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL'));
    }
    else
    {
      $err                      = $_POST['status_desc']." (".$_POST['status'].")";
      #'session missing or returned session is wrong';
      $order->info['comments'] .= '. Novalnet Error Message : '.$err;
      $payment_error_return     = 'payment_error='.$this->code.'&error='.utf8_encode(utf8_encode($err));
      if ($this->is_ajax) {
			xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, $payment_error_return, 'SSL', true, false));
		} else {
			xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
		}
    }
  }
  function encode($data)
  {
    $data = trim($data);
    if ($data == '') return'Error: no data';
    if (!function_exists('base64_encode') or !function_exists('pack') or !function_exists('crc32')){return'Error: func n/a';}

    try {
      $crc = sprintf('%u', crc32($data));# %u is a must for ccrc32 returns a signed value
      $data = $crc."|".$data;
      $data = bin2hex($data.$this->key);
      $data = strrev(base64_encode($data));
    }catch (Exception $e){
      echo('Error: '.$e);
    }
    return $data;
  }
  function decode($data)
  {
    $data = trim($data);
    if ($data == '') {return'Error: no data';}
    if (!function_exists('base64_decode') or !function_exists('pack') or !function_exists('crc32')){return'Error: func n/a';}

    try {
      $data =  base64_decode(strrev($data));
      $data = pack("H".strlen($data), $data);
      $data = substr($data, 0, stripos($data, $this->key));
      $pos = strpos($data, "|");
      if ($pos === false){
        return("Error: CKSum not found!");
      }
      $crc = substr($data, 0, $pos);
      $value = trim(substr($data, $pos+1));
      if ($crc !=  sprintf('%u', crc32($value))){
        return("Error; CKSum invalid!");
      }
      return $value;
    }catch (Exception $e){
      echo('Error: '.$e);
    }
  }
  function hash($h)#$h contains encoded data
  {
    global $amount_zh;
    if (!$h) return'Error: no data';
    if (!function_exists('md5')){return'Error: func n/a';}
    return md5($h['auth_code'].$h['product_id'].$h['tariff'].$h['amount'].$h['test_mode'].$h['uniqid'].strrev($this->key));
  }
  function checkHash($request)
  {
    if (!$request) return false; #'Error: no data';
    $h['auth_code']  = $request['vendor_authcode'];#encoded
    $h['product_id'] = $request['product_id'];#encoded
    $h['tariff']     = $request['tariff_id'];#encoded
    $h['amount']     = $request['amount'];#encoded
    $h['test_mode']  = $request['test_mode'];#encoded
    $h['uniqid']     = $request['uniqid'];#encoded
	//print $request['hash2'] ."<BR>". $this->hash($h);exit;
    if ($request['hash2'] != $this->hash($h)){
      return false;
    }
    return true;
  }

  function checkHash4java($request)
  {
    if (!$request) return false; #'Error: no data';
    $h['auth_code']  = $request['vendor_authcode'];#encoded
    $h['product_id'] = $request['product_id'];#encoded
    $h['tariff']     = $request['tariff_id'];#encoded
    $h['amount']     = $request['amount'];#encoded
    $h['test_mode']  = $request['test_mode'];#encoded
    $h['uniqid']     = $request['uniqid'];#encoded

    if ($request['hash2'] != $this->hash($h)){
      return false;
    }
    return true;
  }

  function encode4java($data = '', $func = ''){
    $salt = 1010;
    if (!isset($data) or trim($data) == '' or !$func){
      return'Error: missing arguments: $str and/or $func!';
    }
    if ($func != 'decbin' and $func != 'bindec'){
      return'Error: $func has wrong value!';
    }
    if ($func == 'decbin'){
      return decbin(intval($data) + intval($salt));
    }else{
      return bindec($data) - intval($salt);
    }
  }
}
/*
flow of functions:
selection              -> $order-info['total'] wrong, cause shipping_cost is net
pre_confirmation_check -> $order-info['total'] wrong, cause shipping_cost is net
confirmation           -> $order-info['total'] right, cause shipping_cost is gross
process_button         -> $order-info['total'] right, cause shipping_cost is gross
before_process         -> $order-info['total'] wrong, cause shipping_cost is net
after_process          -> $order-info['total'] right, cause shipping_cost is gross
---------------
flow of url/path:
/xtcommerce/account.php
/xtcommerce/account_history_info.php
/xtcommerce/address_book.php
/xtcommerce/checkout_shipping.php
/xtcommerce/checkout_shipping.php
/xtcommerce/checkout_payment.php
/xtcommerce/checkout_confirmation.php
*/